#version 330 core

in vec2 UV;
in vec3 Normal_View;
in vec3 Position_World;

out vec3 color;

uniform sampler2D myTextureSampler;
uniform vec3 cameraPosition;

uniform vec3 sharedLightColor;

// Ambient support
uniform float ambientIntensity;

// Diffuse support
uniform vec3 diffuseDir;
uniform float diffuseIntensity;

// Specular support
uniform float specularMatInt;
uniform float specularMatPower;

void main()
{
	vec3 normViewAdj = normalize(Normal_View);

	// Ambient calculation
	vec3 ambientResult = sharedLightColor * ambientIntensity;

	// Diffuse calculation
	float diffuseScalar = max(0, dot(normViewAdj, -diffuseDir)); // Clamp negative values to 0
	vec3 diffuseResult = sharedLightColor * diffuseIntensity * diffuseScalar;

	// Specular calculation
	vec3 viewVector = normalize(cameraPosition - Position_World);
	vec3 reflect = normalize(reflect(normalize(diffuseDir), normViewAdj));
	float specScalar = max(0, dot(-viewVector, reflect));
	specScalar = pow(specScalar, specularMatPower);
	vec3 specResult = sharedLightColor * specularMatInt * specScalar;

	color = texture(myTextureSampler, UV).rgb * (ambientResult + diffuseResult + specResult);
}